/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.network.packets;

import java.util.ArrayList;
import java.util.Collection;
import mezz.jei.common.network.IPacketId;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.ServerPacketData;
import mezz.jei.common.network.packets.PacketJei;
import mezz.jei.common.transfer.BasicRecipeTransferHandlerServer;
import mezz.jei.common.transfer.TransferOperation;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2540;
import net.minecraft.class_3222;

public class PacketRecipeTransfer
extends PacketJei {
    public final Collection<TransferOperation> transferOperations;
    public final Collection<class_1735> craftingSlots;
    public final Collection<class_1735> inventorySlots;
    private final boolean maxTransfer;
    private final boolean requireCompleteSets;

    public PacketRecipeTransfer(Collection<TransferOperation> transferOperations, Collection<class_1735> craftingSlots, Collection<class_1735> inventorySlots, boolean maxTransfer, boolean requireCompleteSets) {
        this.transferOperations = transferOperations;
        this.craftingSlots = craftingSlots;
        this.inventorySlots = inventorySlots;
        this.maxTransfer = maxTransfer;
        this.requireCompleteSets = requireCompleteSets;
    }

    @Override
    public IPacketId getPacketId() {
        return PacketIdServer.RECIPE_TRANSFER;
    }

    @Override
    public void writePacketData(class_2540 buf) {
        buf.method_10804(this.transferOperations.size());
        for (TransferOperation operation : this.transferOperations) {
            operation.writePacketData(buf);
        }
        buf.method_10804(this.craftingSlots.size());
        for (class_1735 craftingSlot : this.craftingSlots) {
            buf.method_10804(craftingSlot.field_7874);
        }
        buf.method_10804(this.inventorySlots.size());
        for (class_1735 inventorySlot : this.inventorySlots) {
            buf.method_10804(inventorySlot.field_7874);
        }
        buf.writeBoolean(this.maxTransfer);
        buf.writeBoolean(this.requireCompleteSets);
    }

    public static void readPacketData(ServerPacketData data) {
        ServerPacketContext context = data.context();
        class_3222 player = context.player();
        class_2540 buf = data.buf();
        class_1703 container = player.field_7512;
        int transferOperationsSize = buf.method_10816();
        ArrayList<TransferOperation> transferOperations = new ArrayList<TransferOperation>(transferOperationsSize);
        for (int i = 0; i < transferOperationsSize; ++i) {
            TransferOperation transferOperation = TransferOperation.readPacketData(buf, container);
            transferOperations.add(transferOperation);
        }
        int craftingSlotsSize = buf.method_10816();
        ArrayList<class_1735> craftingSlots = new ArrayList<class_1735>(craftingSlotsSize);
        for (int i = 0; i < craftingSlotsSize; ++i) {
            int slotIndex = buf.method_10816();
            class_1735 slot = container.method_7611(slotIndex);
            craftingSlots.add(slot);
        }
        int inventorySlotsSize = buf.method_10816();
        ArrayList<class_1735> inventorySlots = new ArrayList<class_1735>();
        for (int i = 0; i < inventorySlotsSize; ++i) {
            int slotIndex = buf.method_10816();
            class_1735 slot = container.method_7611(slotIndex);
            inventorySlots.add(slot);
        }
        boolean maxTransfer = buf.readBoolean();
        boolean requireCompleteSets = buf.readBoolean();
        BasicRecipeTransferHandlerServer.setItems((class_1657)player, transferOperations, craftingSlots, inventorySlots, maxTransfer, requireCompleteSets);
    }
}

